/***************************************
 Mapper227 SanXiaWuYi
 Last Update:20210913
 Need FW403 or newer
***************************************/
function cpu_dump(d, prg_size, crc)
{	
	set_synphi2(d,1);

	//SanXiaoWuYi 227 only
	for(local i = 0; i < (prg_size/0x8000); i += 1)
	{
		cpu_write(d, 0x8083+i*8,0 );
		cpu_read(d, 0x8000, 0x8000);
	}
}
function ram_dump(d, prg_size, banksize)
{
	//cpu_write
	//ram_read_write
	for(local i = 0; i < 0x2000; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);
	cpu_write(d, 0xa001, 0x40);
}

function ppu_dump(d, chr_size, banksize)
{
}

function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	//1000 0000 0000 0000 0000 00X0 1000 0000
	flash_configure(d,0xC000,0xC555,0xC2AA,0xC555);
	
	cpu_write(d,0x8000,0x55);
	cpu_write(d,0x8000,0xAA);
	cpu_write(d,0x8000,0xA5);
	cpu_write(d,0x8000,0xFF);//disable reset

	for(local i = 0; i < (prg_size/0x4000); i += 1){
		cpu_write(d, 0x8080|((i&0x1F)<<2)|((i&0x20)<<3),0 );
		prg_flash(d, 0x8000, 0x4000);
	}
}

