/***************************************
 IREM G101
***************************************/
function cpu_dump(d, prg_size, prg_size_dummy)
{
	local i;
	cpu_write(d,0x9000,0);
	for(i = 0; i < (prg_size/0x2000) - 1; i += 1){
		cpu_write(d, 0x8000, i);
		cpu_read(d, 0x8000, 0x2000);
	}
	cpu_read(d, 0xE000, 0x2000);
}
function ppu_dump(d, chr_size, chr_size_dummy)
{
	for(local i = 0; i < (chr_size/0x400); i += 4){
		//local ar = [i, i|2, i|4, i|5, i|6, i|7];
		cpu_write(d, 0xB000,i,0xB001, i|1,0xB002, i|2,0xB003, i|3);
		ppu_read(d, 0x0000, 0x400 * 4);
	}
}


function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	local i;
	flash_configure(d,0xE555,0xE555,0xEAAA,0xE555);
	cpu_write(d,0x9000,0);
	for(i = 0; i < (prg_size/0x2000) - 1; i += 1){
		cpu_write(d, 0x8000, i);
		prg_flash(d, 0x8000, 0x2000);
	}
	prg_flash(d, 0xE000, 0x2000);
}

function ppu_erase(d, chr_size, chr_size_dummy)
{	
	cpu_write(d, 0xB004, 0);
	cpu_write(d, 0xB005, 1);
	cpu_write(d, 0xB006, 2);
	cpu_write(d, 0xB007, 3);

	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);
	
	for(local i = 0; i < (chr_size/0x400); i += 4){
		//local ar = [i, i|2, i|4, i|5, i|6, i|7];
		cpu_write(d, 0xB000,i,0xB001, i|1,0xB002, i|2,0xB003, i|3);
		chr_flash(d, 0x0000, 0x400 * 4);
	}
}
