/***************************************
 UNROM Mapper2
 Last update:2022/06/03
***************************************/
function cpu_dump(d, prg_size, rst_crc)
{	
	if(rst_crc==0xC14E26F3 )//Rambo (Japan)
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xC2CF+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(rst_crc==0x9E017E41 )//Momotarou Dentetsu 桃太郎電鉄　HFC-M2/220509
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xFFD0+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(rst_crc==0xD3ABB0 )//Argos no Senshi - Hachamecha Daishingeki (Japan)
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xC0D3+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(rst_crc==0x488E2F2E )//Nekketsu Kouha Kunio-kun (Japan)
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xFF2F+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if( (rst_crc==0x94EFA16B)||(rst_crc==0x9143EF26)||(rst_crc==0x29BEE9D1)||(rst_crc==0x4FE796A1) )
	//Rockman (Japan) (En)
	//Makai Mura (Japan) 2022/04/07 
	//Takeshi no Chousenjou 2022/05/09
	//Takeda Shingen (Japan) 2022/05/25
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xC000+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(rst_crc==0x2C008611)
	//Hinotori - Houou Hen - Gaou no Bouken (Japan) 2022/04/07 
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0x8000+i, i);
			cpu_write(d, 0x8000+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(rst_crc==0x955F366 )//Terra Cresta 
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xC556+i, i);
			cpu_write(d, 0xC2DC+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(rst_crc==0x63B3F3E)//Dragon Quest II - Akuryou no Kamigami
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xC2DC+i, i);
			cpu_write(d, 0xC2DC+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(0x5883C8B5==rst_crc)//Daiva - Imperial of Nirsartia/ディーヴァ ナーサティアの玉座
	{
		for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
		{
			cpu_write(d, 0xC17E+i, i);
			cpu_write(d, 0xC17E+i, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}		
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else
	{
		for(local i = 0; i < (prg_size/0x4000) - 1; i += 1){
			//cpu_write(d, 0xFFFF, i);
			cpu_write(d, 0xFFFF, i);
			cpu_read(d, 0x8000, 0x2000 * 2);
		}
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
}
function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8000,0x8555,0x82AA,0x8555);
	
	for(local i = 0; i < (prg_size/0x4000) - 1; i += 1){
		cpu_write(d, 0x8000+i, i);
		cpu_write(d, 0xC000+i, i);
		prg_flash(d, 0x8000, 0x2000 * 2);
	}
	prg_flash(d, 0xc000, 0x2000 * 2);
}
function ppu_dump(d, chr_size, banksize)
{
}