/***************************************
 Sunsoft-3 
 update: FIXED CHR dump bug.
 2018-12-06
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x4000)-1; i += 1){
		cpu_write(d, 0xF800, i);
		cpu_read(d, 0x8000, 0x4000);
	}
	cpu_read(d, 0xC000, 0x4000);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x800; i+=4){
		cpu_write(d, 0x8800, i|0,0x9800, i|1, 0xA800, i|2, 0xB800, i|3);
		ppu_read(d, 0x0000, 0x2000);
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xD555,0xD555,0x8AAA,0xD555);

	for(local i = 0; i < (prg_size/0x4000)-1; i += 1){
		cpu_write(d, 0xF800, i);
		prg_flash(d, 0x8000, 0x4000);
	}
	prg_flash(d, 0xc000, 0x2000 * 2)
}

function ppu_erase(d, chr_size, chr_size_dummy)
{	
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	for(local i = 0; i < (chr_size/0x800); i += 4){
		cpu_write(d, 0x8800, i|0,0x9800, i|1, 0xA800, i|2, 0xB800, i|3);
		chr_flash(d, 0x0000, 0x2000);
	}
}