/***************************************
  Sunsoft-4 mapper IC. 
  Example games: 
   After Burner
   Maharaja (J)
   Nantettatte!! Baseball (J)
  Update 20190622(ppu_dump)

  $F000-$FFFF: PRG-ROM bank
  Map a 16 KiB PRG ROM bank at CPU address $8000-$BFFF.
  Nantettatte!! Baseball repurposes some of the bits:
  7  bit  0
  ---- ----
  ...E RBBB
     | ||||
     | |+++- Select 16 KiB PRG banked into $8000-$BFFF
     | +----   1: select internal ROM
     |         0: select external ROM
     +------ 1: Enable PRG RAM = WRAM +CS2
             0: Enable licensing verification
  Update 20220807(ppu_dump)

***************************************/
function cpu_dump(d, prg_size, crc)
{
	local m_Nantettatte = 0;
	if(crc==0x5a66b1cd)
		m_Nantettatte = 8;
	
	for(local i = 0; i < (prg_size/0x4000) - 1; i += 1){
		cpu_write(d, 0xF000, i|m_Nantettatte);
		cpu_read(d, 0x8000, 0x4000);
	}
	cpu_read(d, 0xC000, 0x4000);
}
function ppu_dump(d, chr_size, banksize)
{
	cpu_write(d,0xE000,1<<0);
	for(local i = 0; i < chr_size/0x800; i+=4){
		cpu_write(d, 0x8000, i|0,0xA000, i|2);
		cpu_write(d, 0x9000, i|1,0xB000, i|3);
		ppu_read(d, 0x0000, 0x800*4);
	}
}