function cpu_dump(d, prg_size, prg_size_dummy)
{	
	for(local i = 0; i < (prg_size/0x8000) ; i += 1){
		cpu_write(d, 0xC000, i<<1);
		cpu_read(d, 0x8000, 0x8000);
	}
}
function ppu_dump(d, chr_size, chr_size_dummy)
{
	for(local i = 0; i < chr_size/0x2000; i+=1){
		cpu_write(d, 0xC000,i);
		ppu_read(d,0x0000, 0x2000);
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8555,0x8555,0x8AAA,0x8555);

	for(local i = 0; i < (prg_size/0x8000); i += 1){
		cpu_write(d, 0xC000, i<<1);
		prg_flash(d, 0x8000, 0x2000*4);
	}
}
function ppu_erase(d, chr_size, chr_size_dummy)
{	
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	cpu_write(d,0x4100,0x1);
	for(local i = 0; i < (chr_size/0x2000); i += 1){

		cpu_write(d, 0x8000, i);
		chr_flash(d, 0x0000, 0x2000);
	}
}
