/***************************************
 Mapper15
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	//1000 0000 0000 0010 0DDD DDDD	
	for(local i = 0; i < (prg_size/0x4000); i += 1){
		cpu_write(d, 0x8000, i|0x80);
		cpu_read(d, 0x8000, 0x2000);
		cpu_write(d, 0x8000, i|0x00);
		cpu_read(d, 0x8000, 0x2000);
	}
}
function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xE555,0xE555,0xEAAA,0xE555);

	for(local i = 0; i < (prg_size/0x4000); i += 1){
		cpu_write(d, 0x8000, i|0x80);
		prg_flash(d, 0x8000, 0x2000);
		cpu_write(d, 0x8000, i|0x00);
		prg_flash(d, 0x8000, 0x2000);
	}
}