﻿/***************************************
 MMC3 Base Mapper45
 Last Update:20210913
 Need FW403 or newer
***************************************/
function cpu_dump(d, prg_size, crc)
{
	set_synphi2(d,1);
	
	for(local i = 0; i < (prg_size/0x2000); i += 2)
	{
		local v1 = ((i/32)&7)<<5;
		local v2 = ((i/32)&15)<<4;
		
		cpu_write(d,0x6000,0x00);
		cpu_write(d,0x6000,v1);
		cpu_write(d,0x6000,v2);
		cpu_write(d,0x6000,0xA0);
		cpu_write(d,0x8000,6);
		cpu_write(d,0x8001,i);
		cpu_write(d,0x8000,7);
		cpu_write(d,0x8001,i|1);
		
		cpu_read(d,0x8000,0x4000);
	}
}
function ppu_dump(d, chr_size, crc)
{
	for(local i = 0; i < chr_size/0x400; i+=8)
	{
		local v1 = ((i/256)&7)<<5;
		local v2 = (((i/256)&0xF)<<4)|0xF;
			
		cpu_write(d,0x6000,0x00);
		cpu_write(d,0x6000,v1);
		cpu_write(d,0x6000,v2);
		cpu_write(d,0x6000,0xA0);
		cpu_write(d,0x8000,0);
		cpu_write(d,0x8001,i);
		cpu_write(d,0x8000,1);
		cpu_write(d,0x8001,i|2);
		cpu_write(d,0x8000,2);
		cpu_write(d,0x8001,i|4);
		cpu_write(d,0x8000,3);
		cpu_write(d,0x8001,i|5);
		cpu_write(d,0x8000,4);
		cpu_write(d,0x8001,i|6);
		cpu_write(d,0x8000,5);
		cpu_write(d,0x8001,i|7);
		
		ppu_read(d,0x0000,0x2000);
	}
}