/***************************************
 FME-7 Mapper69
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	cpu_write(d, 0xa001, 0); //disable W-RAM
	for(local i = 0; i < (prg_size/0x2000) - 1; i += 1){
		cpu_write(d, 0x8000, 9,0xA000,i);
		cpu_read(d, 0x8000, 0x2000);
	}
	cpu_read(d, 0xE000, 0x2000);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x400; i+=8){
		cpu_write(d, 0x8000,0,0xA000, i|0,0x8000,1,0xA000, i|1);
		cpu_write(d, 0x8000,2,0xA000, i|2,0x8000,3,0xA000, i|3);
		cpu_write(d, 0x8000,4,0xA000, i|4,0x8000,5,0xA000, i|5);
		cpu_write(d, 0x8000,6,0xA000, i|6,0x8000,7,0xA000, i|7);
		ppu_read(d, 0x0000, 0x400 * 8);
	}
}
function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d,0x8000,0x08);
	cpu_write(d,0xA000,0x40);
	
	cpu_write_flash(d,0xE555,0xF0);
	cpu_write_flash(d,0xE555,0xAA);
	cpu_write_flash(d,0xE2AA,0x55);
	cpu_write_flash(d,0xE555,0x80);
	cpu_write_flash(d,0xE555,0xAA);
	cpu_write_flash(d,0xE2AA,0x55);
	cpu_write_flash(d,0xE555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xE000,0xE555,0xE2AA,0xE555);

	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0x8000, 0xB);
		cpu_write(d, 0xA000, i);
		prg_flash(d, 0xC000, 0x2000);
	}
	prg_flash(d, 0xE000, 0x2000);
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	
	cpu_write(d, 0x8000, 0);//0-800
	cpu_write(d, 0xA000, 0);
	cpu_write(d, 0x8000, 1);//800-1000
	cpu_write(d, 0xA000, 1);
	
	ppu_write(d,0x555,0xF0);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x80);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x555,0x555,0x2AA,0x555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		cpu_write(d, 0x8000,4,0xA001,i,0x8000,5,0xA001,i|1 ,0x8000,6,0xA001,i|2 ,0x8000,7,0xA001,i|3);
		chr_flash(d, 0x1000, 0x1000);
	}
}
