/***************************************
 Mapper90 Final Fighter 3
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000) - 1; i += 1){
		cpu_write(d, 0x8000, i);
		cpu_read(d, 0x8000, 0x2000);
	}
	cpu_read(d, 0xE000, 0x2000);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x400; i+=4){
		if(i==256)
		{
		cpu_write(d, 0xA000,1,0xA001,1);
		cpu_write(d, 0xA002,1,0xA003,1);
		}		
		if(i==0)
		{
		cpu_write(d, 0xA000,0,0xA001,0);
		cpu_write(d, 0xA002,0,0xA003,0);
		}
		cpu_write(d, 0x9000,i|0,0x9001,i | 1);
		cpu_write(d, 0x9002,i|2,0x9003,i | 3);
		ppu_read(d, 0x0000, 0x400 * 4);
	}
}


function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xD555,0xD555,0x8AAA,0xD555);

	for(local i = 0; i < (prg_size/0x2000); i += 1){
		cpu_write(d, 0x8000, i);
		prg_flash(d, 0x8000, 0x2000);
	}
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0x9000, 0);//-
	cpu_write(d, 0x9001, 1);// 
	cpu_write(d, 0x9002, 2);//
	cpu_write(d, 0x9003, 3);// 
	cpu_write(d, 0x9004, 0);// 
	cpu_write(d, 0x9005, 1);// 
	cpu_write(d, 0x9006, 2);// 
	cpu_write(d, 0x9007, 3);// 
	
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		if(i==0)
		{
		cpu_write(d, 0xA000,0,0xA001,0);
		cpu_write(d, 0xA002,0,0xA003,0);
		}		
		if(i==256)
		{
		cpu_write(d, 0xA000,1,0xA001,1);
		cpu_write(d, 0xA002,1,0xA003,1);
		}
		
		cpu_write(d, 0x9000, i|0);
		cpu_write(d, 0x9001, i|1);
		cpu_write(d, 0x9002, i|2);
		cpu_write(d, 0x9003, i|3);
		chr_flash(d, 0x0000, 0x1000);
	}
}