/***************************************
 Namco Mapper19
 20190308 Add Flash command
 
 Not support sram read(220508):Famista '90/ファミスタ’９０
 $4800 Expand I/O Data Register
 $F800 Expand I/O Address Register
 bit Iaaaaaaa
 aaaaaaa: Address(Max 128Bytes)
 I: Auto Increment Enable/Disable 1:Enable 0:Disable
   1にすると、$4800のアクセスで自動的にアドレスが１増加される
 for(local i = 0; i < 0x80; i += 1)
 {
	cpu_write(d, 0xF800, i);
	ram_read_write(d, 0x4800, 1);
 }
   
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0xE000,i);
		cpu_read(d, 0x8000, 0x2000);
	}
	cpu_read(d, 0xE000, 0x2000);
}
function ppu_dump(d, chr_size, banksize)
{
	cpu_write(d, 0xE800,0xC0);
	for(local i = 0; i < chr_size/0x400; i+=8){
		//cpu_write(d, 0x8000,i|0);
		//cpu_write(d, 0x8800,i|1);
		//cpu_write(d, 0x9000,i|2);
		//cpu_write(d, 0x9800,i|3);
		//cpu_write(d, 0xA000,i|4);
		//cpu_write(d, 0xA800,i|5);
		//cpu_write(d, 0xB000,i|6);
		//cpu_write(d, 0xB800,i|7);
		cpu_write(d, 0x8000,i|0,0x8800,i|1,0x9000,i|2,0x9800,i|3,0xA000,i|4,0xA800,i|5,0xB000,i|6,0xB800,i|7);
		ppu_read(d, 0x0000, 0x2000);
	}
}
function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d, 0xF800, 0xF); //disable W-RAM
	
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}

function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8555,0x8555,0x8AAA,0x8555);

	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0xE000, i);
		prg_flash(d, 0x8000, 0x2000);
	}
	prg_flash(d, 0xe000, 0x2000);
}


function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0xE800, 0); //disable CHR-RAM
	
	cpu_write(d, 0x8000, 0);
	cpu_write(d, 0x8800, 1);
	cpu_write(d, 0x9000, 2);
	cpu_write(d, 0x9800, 3);

	
	ppu_write(d,0x555,0xF0);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x80);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x555,0x555,0x2AA,0x555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		cpu_write(d, 0xa000, 0);
		cpu_write(d, 0xa800, i|1);
		cpu_write(d, 0xb000, i|2);
		cpu_write(d, 0xb800, i|3);
		chr_flash(d, 0x1000, 0x1000);
	}
}

function ram_dump(d, prg_size, banksize)
{
	cpu_write(d, 0xF800, 0x40); //enable W-RAM

	for(local i = 0; i < 0x2000; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);

	cpu_write(d, 0xf800, 0x0F); //enable W-RAM
}