/***************************************
 UNROM Mapper2
 Last update:2024/10/29
***************************************/
function cpu_dump(d, prg_size, rst_crc)
{
	local address = 0xC000;
	
	if( rst_crc==0x967CC61B )//WWW
		address=0xFFD8;
	if( rst_crc==0x2EB1D8FB )//Batsu & Terry - Makyou no Tetsujin Race (Japan)
		address=0xC290;
	else if( rst_crc==0x7E4438E9 )//Top Gun (Japan)
		address=0xFFD0;
	else if( rst_crc==0x909BD4B4 )//Little Mermaid - Ningyo Hime (Japan)
		address=0xFFDE;
	else if( rst_crc==0x1A8474FC )//Toki no Tabibito (Japan)
		address=0xC41D;
	else if( rst_crc==0x81234346 )//Kamen no Ninja - Akakage (Japan)
		address=0xDA15;
	else if(rst_crc==0xDF926938 )//Wanpaku Duck Yume Bouken (Japan)
		address=0xFFDB;
	else if( (rst_crc==0xECAC647D)||(rst_crc==0x463DFA1F) )//Hector '87 (Japan) //Labyrinth (Japan) 20241011
		address=0xFFF0;
	else if(rst_crc==0xC14E26F3 )//Rambo (Japan)
		address=0xC2CF;
	else if(rst_crc==0x9E017E41 )//Momotarou Dentetsu 桃太郎電鉄　HFC-M2/220509
		address=0xFFD0;
	else if(rst_crc==0xD3ABB0 )//Argos no Senshi - Hachamecha Daishingeki (Japan)
		address=0xC0D3;
	else if(rst_crc==0x488E2F2E )//Nekketsu Kouha Kunio-kun (Japan)
		address=0xFF2F;
	//else if( (rst_crc==0x448B3AEC)||(rst_crc==0x94EFA16B)||(rst_crc==0x9143EF26)||(rst_crc==0x29BEE9D1)||(rst_crc==0x4FE796A1)||(rst_crc==0x30811A57))//Rockman (Japan) (En)//Makai Mura (Japan)//Takeshi no Chousenjou //Takeda Shingen (Japan)//Houma ga Toki (Japan)//Tsuri Kichi Sanpei - Blue Marlin Hen (Japan)
	//	address=0xC000;
	else if(rst_crc==0x2C008611)//Hinotori - Houou Hen - Gaou no Bouken (Japan) 2022/04/07 
		address=0x8000;
	else if( (rst_crc==0x955F366 )||(rst_crc==0x63B3F3E) )//Terra Cresta //DQ2
		address=0xC2DC;
	else if(0x5883C8B5==rst_crc)//Daiva - Imperial of Nirsartia/ディーヴァ ナーサティアの玉座
		address=0xC17E;
	
	for(local i = 0; i < (prg_size/0x4000)-1; i += 1)
	{
		cpu_write(d, address+i, i);
		cpu_read(d, 0x8000, 0x4000);
	}		
	cpu_read(d, 0xc000, 0x4000);
}
function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8000,0x8555,0x82AA,0x8555);
	
	for(local i = 0; i < (prg_size/0x4000) - 1; i += 1){
		cpu_write(d, 0x8000+i, i);
		cpu_write(d, 0xC000+i, i);
		prg_flash(d, 0x8000, 0x2000 * 2);
	}
	prg_flash(d, 0xc000, 0x2000 * 2);
}
function ppu_dump(d, chr_size, banksize)
{
}