/***************************************
 MMC3 Mapper47
 128K Base multicart
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	cpu_write(d, 0xA000, 0x01);
	cpu_write(d, 0xA001, 0x80);
	cpu_write(d, 0x6000, 0x00);
	for(local i = 0; i < (prg_size/0x2000); i += 1)
	{					
		if(i==16)
		{
			cpu_write(d, 0xA000, 0x01);
			cpu_write(d, 0xA001, 0x80);
			cpu_write(d, 0x6000, 0x01);
		}
		cpu_write(d, 0x8000, 6);
		cpu_write(d, 0x8001, i);
		cpu_read(d, 0x8000, 0x2000);
	}
}
function ppu_dump(d, chr_size, banksize)
{
	cpu_write(d, 0xA000, 0x01);
	cpu_write(d, 0xA001, 0x80);
	cpu_write(d, 0x6000, 0x00);
	for(local i = 0; i < chr_size/0x400; i+=2)
	{				
		if(i==128)
		{
			cpu_write(d, 0xA000, 0x01);
			cpu_write(d, 0xA001, 0x80);
			cpu_write(d, 0x6000, 0x01);
		}
		cpu_write(d, 0x8000,0);
		cpu_write(d, 0x8001,i);
		ppu_read(d, 0x0000, 0x400 * 2);
	}
}