function cpu_dump(d, prg_size, prg_size_dummy)
{
	show_log(d, "dump mapper0");
	
	if(prg_size==0x4000)
		cpu_read(d, 0xc000, 0x4000);
	else//32k
		cpu_read(d, 0x8000, 0x8000);		
}
function ppu_dump(d, chr_size, chr_size_dummy)
{
	if(chr_size==0x2000)
	ppu_read(d, 0x0000, 0x2000);
}

function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}

function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8000,0x8555,0x82AA,0x8555);
	
	show_log(d, "flash mapper0");
	
	if(prg_size==0x4000)
		prg_flash(d, 0xc000, 0x4000);
	else if(prg_size==0x8000)//32k
		prg_flash(d, 0x8000, 0x8000);
	else{
		for(local i=0; i<prg_size/0x8000;i++)
		{
			cpu_write(d,0x5000,i);
			prg_flash(d, 0x8000, 0x8000);
		}			
	}
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}

function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);
	if(chr_size>0x2000)
	{
		for(local i=0; i<chr_size/0x2000;i++)
		{
			cpu_write(d,0x5000,i);
			chr_flash(d, 0x0000, 0x2000);
		}
	}
	else
		chr_flash(d, 0x0000, 0x2000);
}


function ram_dump(d, prg_size, banksize)
{
	//cpu_write
	//ram_read_write
	for(local i = 0; i < 0x2000; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);
}