/***************************************
 MMC3 116
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	cpu_write(d, 0xa001, 0); //disable W-RAM
	for(local i = 0; i < (prg_size/0x2000) - 2; i += 1){
		cpu_write(d, 0x8000, 6);
		cpu_write(d, 0x8001, i);
		//cpu_write(d, 0x8000, 7);
		//cpu_write(d, 0x8001, i | 1);
		cpu_read(d, 0x8000, 0x2000);
	}
	cpu_read(d, 0xc000, 0x2000 * 2);
}
function ppu_dump(d, chr_size, banksize)
{
	cpu_write(d,0x4100,0x1);
	for(local i = 0; i < chr_size/0x400; i+=4)
	{
		if(i==256) cpu_write(d,0x4100,0x5);
		cpu_write(d, 0x8000,2,0x8001, i,  0x8000, 3,0x8001, i | 1);
		cpu_write(d, 0x8000,4,0x8001, i|2,0x8000, 5,0x8001, i | 3);
		ppu_read(d, 0x1000, 0x400 * 4);
	}
}


function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d,0x4100,0x1);
	//5555 bank x 0xD555
	//2AAA bank 1 0x8AAA
	cpu_write(d,0x8000,0x6);
	cpu_write(d,0x8001,0x1);
	
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xD555,0xD555,0x8AAA,0xD555);

	for(local i = 0; i < (prg_size/0x2000)-2; i += 1){
		cpu_write(d, 0x8000, 7);
		cpu_write(d, 0x8001, i);
		prg_flash(d, 0xa000, 0x2000);
	}
	prg_flash(d, 0xc000, 0x2000 * 2)
}
function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d,0x4100,0x1);
	
	//ppu_command(d, 0x0000, 0x1000, ppu_banksize);
	//ppu_command(d, 0x2aaa, 0x0000, 0x0800);//2AA+2800(0x0A)
	//ppu_command(d, 0x5555, 0x0800, 0x0800);//155+5400(0x15)
	cpu_write(d, 0x8000, 2);//1000-400
	cpu_write(d, 0x8001, 0x0A);	// 0x12AA
	cpu_write(d, 0x8000, 3);//1000-400
	cpu_write(d, 0x8001, 0x15);// 0x1555

	
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	cpu_write(d,0x4100,0x1);//MMC3
	for(local i = 0; i < (chr_size/0x400); i += 4){
		if(i==256)
			cpu_write(d,0x4100,0x5);//101
		cpu_write(d, 0x8000, 0);
		cpu_write(d, 0x8001, i|0);
		cpu_write(d, 0x8000, 1);
		cpu_write(d, 0x8001, i|2);
		chr_flash(d, 0x0000, 0x1000);
	}
}