/***************************************
 Mapper 210
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000) - 1; i += 1){
        cpu_write(d, 0xE800, i);
		cpu_read(d, 0xA000, 0x2000);
	}
	cpu_read(d, 0xe000, 0x2000);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x400; i+=4){
		cpu_write(d, 0x8000, i|0,  0x8800, i | 1);
		cpu_write(d, 0x9000, i|2,  0x9800, i | 3);
		ppu_read(d, 0x0000, 0x400 * 4);
	}
}

function ram_dump(d, prg_size, banksize)
{
	cpu_write(d, 0xC000, 1); //enable W-RAM
	for(local i = 0; i < (prg_size/0x2000); i += 1){
		cpu_read(d, 0x6000, 0x2000);
    }
    cpu_write(d, 0xC000, 0);
}
