/***************************************
 VRC2A Mapper22
***************************************/
function vrc4_cpu_dump(d, pagesize, banksize, r0, r1)
{
	local a2 = 1 << r1;
	cpu_write(d, 0x9000 | a2, 0);
	for(local i = 0; i < pagesize - 2; i += 2){
		cpu_write(d, 0x8000, i);
		cpu_write(d, 0xa000, i | 1);
		cpu_read(d, 0x8000, banksize * 2);
	}
	cpu_write(d, 0x9000 | a2, 0x02);
	cpu_write(d, 0x8000, 0x1e);
	cpu_read(d, 0xc000, banksize * 2);
}
function cpu_dump(d,prg_size,prg_size_dummy)
{
	vrc4_cpu_dump(d,prg_size/0x2000,0x2000, 1, 0);
}
function vrc2a_ppubank_set(d, addr, i, j, r0, r1)
{
	local a1 = 1 << r0;
	local a2 = 1 << r1;
	local a3 = a1|a2;

	//cpu_write(d, addr | a1, i >> 3);
	//cpu_write(d, addr, i << 1);
	//cpu_write(d, addr | a3, j >> 3);
	//cpu_write(d, addr | a2, j << 1);
	cpu_write(d,addr | a1, i >> 3,addr, i << 1,addr | a3, j >> 3, addr | a2, j << 1);
}

function ppu_dump(d,chr_size,chr_size_dummy)
{
	local r0 = 1;
	local r1 = 0;

	for(local i = 0; i <chr_size/0x400; i += 8){
		vrc2a_ppubank_set(d, 0xb000, i | 0, i | 1, r0, r1);
		vrc2a_ppubank_set(d, 0xc000, i | 2, i | 3, r0, r1);
		vrc2a_ppubank_set(d, 0xd000, i | 4, i | 5, r0, r1);
		vrc2a_ppubank_set(d, 0xe000, i | 6, i | 7, r0, r1);
		ppu_read(d, 0x0000,0x400* 8);
	}
}