/***************************************
 VRC6b Mapper26
 20200130
***************************************/
function cpu_dump(d,prg_size,prg_size_dummy)
{
	for(local i = 0; i < prg_size/0x2000 - 1; i += 1){
		cpu_write(d, 0xC000, i);
		cpu_read(d, 0xC000, 0x2000);
	}
	cpu_read(d, 0xE000, 0x2000);
}


function ppu_dump(d, chr_size, chr_size_dummy)
{
	cpu_write(d,0xB003,0x00);
	for(local i = 0; i < chr_size/0x400; i += 1){
		cpu_write(d, 0xD000, i);
		ppu_read(d, 0x0000, 0x400);
	}
}


function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d,0xB003,0x00);
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xC000,0xC555,0xC2AA,0xC555);
	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0xC000, i);
		prg_flash(d, 0xC000, 0x2000);
	}
	prg_flash(d, 0xE000, 0x2000);
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0xD000, 0);
	cpu_write(d, 0xD002, 1);
	
	ppu_write(d,0x555,0xF0);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x80);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x555,0x555,0x2AA,0x555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		cpu_write(d, 0xE000, i|0);
		cpu_write(d, 0xE002, i|1);
		cpu_write(d, 0xE001, i|2);
		cpu_write(d, 0xE003, i|3);
		chr_flash(d, 0x1000, 0x1000);
	}
}

