/***************************************
 Mapper 86 Jaleco's JF-13
 7  bit  0
 .CPP ..CC
  |||   ||
  |++------ Select 32 KiB PRG bank at $8000
  +-----++- Select 8 KiB CHR bank at $0000

***************************************/
function cpu_dump(d, prg_size, banksize)
{
    for(local i = 0; i < prg_size/0x8000; i+=1)
    {
        cpu_write(d, 0x6000, i<<4);
        cpu_read(d, 0x8000, 0x8000);
    }
}
function ppu_dump(d, chr_size, banksize)
{
    for(local i = 0; i < chr_size/0x2000; i+=1)
    {
        cpu_write(d, 0x6000,((i<<4)&0x40)|(i&0x3) );
        ppu_read(d, 0x0000, 0x2000);
    }
}
