/*Sunsoft 
 Registers **BUS CONFLICTS**:
 --------------------------
 
   $8000-FFFF:  [CPPP MCCC]
     C = Select 8k CHR @ $0000
     P = Select 16k PRG @ $8000
     M = Mirroring:
       0 = 1ScA
       1 = 1ScB
	   
 Last update:2022/04/07 
*/
function cpu_dump(d, prg_size, crc)
{
    for(local i = 0; i < (prg_size/0x4000)-1; i+=1)
	{
		cpu_write(d, 0xc000,(i&7)<<4);
		cpu_read(d, 0x8000, 0x4000);
	}
	cpu_read(d, 0xc000, 0x4000);
}
function ppu_dump(d, chr_size, crc)
{
    for(local i = 0; i < chr_size/0x2000; i+=1){
		
		cpu_write(d, 0xC000+((i&8)<<4)|(i&0x7),((i&8)<<4)|(i&0x7));
		ppu_read(d, 0x0000, 0x2000);
	}
}