/***************************************************************************
 	SUNSOFT-2
    Last update:2022/05/09
 
	   $8000-FFFF:  [.PPP ...E]
     P = PRG Reg  (16k @ $8000)
     E = CHR RAM enable:
         0 = RAM is disabled; writes are ignored and reads are open bus
             (like iNES Mapper 185 except no games use this)
         1 = normal operation.
	Fantasy Zone:Both use 0x6000(Bit0-2) and 0x8000(Bit4-6)
***************************************************************************/
function cpu_dump(d, prg_size, rst_crc)
{	
	for(local i = 0; i < (prg_size/0x4000) - 1; i += 1)
	{
		if(0x6231539C==rst_crc)//Fantasy Zone
		{
			cpu_write(d, 0x6000, i);
			cpu_write(d, 0xCC75+i, 1|(i<<4));			
		}
		else
		{
			cpu_write(d, 0xFFD8+i, (i<<4)|1);
		}
		cpu_read(d, 0x8000, 0x2000 * 2);
	}
	cpu_read(d, 0xc000, 0x2000 * 2);
	
}
function ppu_dump(d, chr_size, banksize)
{
}