/***************************************
 VRC4A Mapper21
 last update 20201108
***************************************/
function vrc4_cpu_dump(d, pagesize, banksize, r0, r1)
{
	local a2 = 1 << r1;
	cpu_write(d, 0x9000 | a2, 0);
	for(local i = 0; i < pagesize - 2; i += 2){
		cpu_write(d, 0x8000, i);
		cpu_write(d, 0xa000, i | 1);
		cpu_read(d, 0x8000, banksize * 2);
	}
	cpu_write(d, 0x9000 | a2, 0x02);
	cpu_write(d, 0x8000, 0x1e);
	cpu_read(d, 0xc000, banksize * 2);
}
function cpu_dump(d,prg_size,crc)
{
	//Ganbare Goemon Gaiden 2 - Tenka no Zaihou
	//<feature name="vrc4-pin3" value="PRG A7" />
	//<feature name="vrc4-pin4" value="PRG A6" />
	//9080:01
	//9000:00
	//8000:xx BANK:8000-9fff
	//A000:xx BANK:a000-Bfff
	if(0x186C4366==crc)
	{
		show_log(d, "Ganbare Goemon Gaiden 2 - Tenka no Zaihou");	
		//vrc4_cpu_dump(d,prg_size/0x2000,0x2000, 6, 7);		
		cpu_write(d, 0x9080, 0x1);
		for(local i = 0; i < prg_size/0x2000 - 1; i += 1){
			cpu_write(d, 0xa000, i);
			cpu_read(d, 0xA000, 0x2000);
		}
		cpu_read(d, 0xE000, 0x2000);
	}
	else
		vrc4_cpu_dump(d,prg_size/0x2000,0x2000, 1, 2);
}


function ppu_bank_set(d, addr, i, j, r0, r1)
{
	local a1 = (1 << r0);
	local a2 = (1 << r1);
	local a3 = a1 | a2;

	//cpu_write(d, addr | a1, i >> 4);
	//cpu_write(d, addr, i & 0xf);
	//cpu_write(d, addr | a3, j >> 4);
	//cpu_write(d, addr | a2, j & 0xf);
	cpu_write(d, addr | a1, i >> 4,addr, i & 0xf,addr | a3, j >> 4,addr | a2, j & 0xf);
}
function vrc4_ppu_dump(d, pagesize, banksize, r0, r1)
{
	for(local i = 0; i < pagesize; i += 8){
		ppu_bank_set(d, 0xb000, i | 0, i | 1, r0, r1);
		ppu_bank_set(d, 0xc000, i | 2, i | 3, r0, r1);
		ppu_bank_set(d, 0xd000, i | 4, i | 5, r0, r1);
		ppu_bank_set(d, 0xe000, i | 6, i | 7, r0, r1);
		ppu_read(d, 0x0000, banksize * 8);
	}
}

function ppu_dump(d,chr_size,reset_crc)
{
	if(reset_crc==0x4a0132df)//wai wai world 2
		vrc4_ppu_dump(d, chr_size/0x400, 0x400, 1, 2);
	else
		vrc4_ppu_dump(d, chr_size/0x400, 0x400, 6, 7);
}