/***************************************
 MMC3 Mapper4
***************************************/
function cpu_dump(d, prg_size, crc)
{
	if(crc==0xAF22332C)//Super Chinese
	{		
		cpu_write(d, 0x8000, 6);
		cpu_write(d, 0x8001, 0xC);
		cpu_write(d, 0x8000, 7);
		cpu_write(d, 0x8001, 0xD);
		cpu_read(d, 0x8000, 0x2000 * 2);
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(crc==0x55560324)//Magic Dragon  MMC3 Base
	{
		show_log(d, "Magic Dragon");
		//8000 C7
		//8003 3D
		for(local i = 0; i < (prg_size/0x2000) - 2; i += 2)
		{
			cpu_wd(d,0x8000,0x4000,0x5700,0x1c,0x8000,6,0x8001,i,0x8000,7,0x8001,i|1);
		}
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
	else if(0x57d28cb3==crc)//HARADIUS ZERO
	{
		show_log(d, "HARADIUS ZERO");
		
		for(local i = 0; i < (prg_size/0x2000) - 1; i += 1)
		{
			cpu_wd(d,0xA000,0x2000,0x8000,0xC7,0x8003,i);
		}
		cpu_read(d, 0xE000, 0x2000);
	}
	else{
		cpu_write(d, 0xa001, 0); //disable W-RAM
		for(local i = 0; i < (prg_size/0x2000) - 2; i += 2){
			cpu_write(d, 0x8000, 6);
			cpu_write(d, 0x8001, i);
			cpu_write(d, 0x8000, 7);
			cpu_write(d, 0x8001, i | 1);
			cpu_read(d, 0x8000, 0x4000);
		}
		cpu_read(d, 0xc000, 0x2000 * 2);
	}
}
function ppu_dump(d, chr_size, crc)
{
	if(crc==0xAF22332C)//Super Chinese
	{
		for(local i = 0; i < (chr_size/0x400) ; i += 8)
		{
			cpu_write(d, 0x8000, 5);
			cpu_write(d, 0x8001, 0x17+i);
			cpu_write(d, 0x8000, 4);
			cpu_write(d, 0x8001, 0x16+i);
			cpu_write(d, 0x8000, 3);
			cpu_write(d, 0x8001, 0x15+i);
			cpu_write(d, 0x8000, 2);
			cpu_write(d, 0x8001, 0x14+i);
			cpu_write(d, 0x8000, 1);
			cpu_write(d, 0x8001, 0x12+i);
			cpu_write(d, 0x8000, 0);
			cpu_write(d, 0x8001, 0x10+i);			
			ppu_read(d, 0x0000, 0x400 * 8);			
		}
	}
	else if(crc==0x55560324)//Magic Dragon  MMC3 Base
	{		
		for(local i = 0; i < (chr_size/0x400) ; i += 4)
		{			
			ppu_wd(d,0x0000,0x1000,0x5700,0x1c,0x8000,0,0x8001,i,0x8000,1,0x8001,i|2);
		}
	}	
	else if(0x57d28cb3==crc)//HARADIUS ZERO
	{
		for(local i = 0; i < (chr_size/0x400) ; i += 1)
		{			
			ppu_wd(d,0x0000,0x400,0x9780,0xC2,0x9787,i);
		}
	}
	else
	for(local i = 0; i < chr_size/0x400; i+=8)
	{
		cpu_write(d, 0x8000,0,0x8001, i|0);
		cpu_write(d, 0x8000,1,0x8001, i|2);
		cpu_write(d, 0x8000,2,0x8001, i|4);
		cpu_write(d, 0x8000,3,0x8001, i|5);
		cpu_write(d, 0x8000,4,0x8001, i|6);
		cpu_write(d, 0x8000,5,0x8001, i|7);
		ppu_read(d, 0x0000, 0x400 * 8);
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d, 0xa001, 0); //disable W-RAM
	/*        
	5555 aa  555 aa(not cares a11->a18)
	2aaa 55  2aa 55
	5555 80  555 80
	5555 aa  555 aa
	2aaa 55  2aa 55
	5555 10  555 10
	*/
	cpu_write(d,0x8000,0x6);
	cpu_write(d,0x8001,0x1);
	
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	/*
	5555 aa
	2aaa 55
	5555 90
	xxxx dd
	*/
	cpu_write(d,0x8000,0x6);
	cpu_write(d,0x8001,0x1);//8000-9FFF = 2000-3FFF
	flash_configure(d,0xD555,0xD555,0x8AAA,0xD555);

	for(local i = 0; i < (prg_size/0x2000)-2; i += 1){
		cpu_write(d, 0x8000, 7);
		cpu_write(d, 0x8001, i);
		prg_flash(d, 0xa000, 0x2000);
	}
	prg_flash(d, 0xc000, 0x2000 * 2)
}

function ppu_erase(d, chr_size, chr_size_dummy)
{	/*
	5555 aa
	2aaa 55
	5555 80
	5555 aa
	2aaa 55
	5555 10
	*/
	cpu_write(d, 0x8000, 0);
	cpu_write(d, 0x8001, 0x0A);//0000-07FF = 2800-2FFF
	cpu_write(d, 0x8000, 1);
	cpu_write(d, 0x8001, 0x14);//0800-0FFF = 5000-5FFF
	
	
	ppu_write(d,0x0D55,0xF0);
	ppu_write(d,0x0D55,0xAA);
	ppu_write(d,0x02AA,0x55);
	ppu_write(d,0x0D55,0x80);
	ppu_write(d,0x0D55,0xAA);
	ppu_write(d,0x02AA,0x55);
	ppu_write(d,0x0D55,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x0D55,0x0D55,0x02AA,0x0D55);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		cpu_write(d, 0x8000, 2);
		cpu_write(d, 0x8001, i);
		cpu_write(d, 0x8000, 3);
		cpu_write(d, 0x8001, i | 1);
		cpu_write(d, 0x8000, 4);
		cpu_write(d, 0x8001, i | 2);
		cpu_write(d, 0x8000, 5);
		cpu_write(d, 0x8001, i | 3);
		chr_flash(d, 0x1000, 0x1000);
	}
}

function ram_dump(d, prg_size, banksize)
{
	//cpu_write
	//ram_read_write
	cpu_write(d, 0xa001, 0x80);
	for(local i = 0; i < 0x2000; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);
	cpu_write(d, 0xa001, 0x40);
}