/***************************************
 VRC7
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0x8000, i);
		cpu_read(d, 0x8000, 0x2000);
	}
	cpu_read(d, 0xE000, 0x2000);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x400; i+=8){
		cpu_write(d, 0xA000,i|0,0xA008, i|1,0xB000,i|2,0xB008, i | 3);
		cpu_write(d, 0xC000,i|4,0xC008, i|5,0xD000,i|6,0xD008, i | 7);
		ppu_read(d, 0x0000, 0x400 * 8);
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d, 0xa001, 0); //disable W-RAM
	//5555 bank x 0xD555
	//2AAA bank 1 0x8AAA
	cpu_write(d,0x8000,0x6);
	cpu_write(d,0x8001,0x1);
	
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xD555,0xD555,0x8AAA,0xD555);

	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0x8000, i);
		prg_flash(d, 0x8000, 0x2000);
	}
	prg_flash(d, 0xE000, 0x2000);
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		cpu_write(d, 0x8000, 0);
		cpu_write(d, 0x8001, i|0);
		cpu_write(d, 0x8000, 1);
		cpu_write(d, 0x8001, i|2);
		chr_flash(d, 0x0000, 0x1000);
	}
}

function ram_dump(d, prg_size, banksize)
{
	//cpu_write
	//ram_read_write
	cpu_write(d, 0xE000, 0x80);
	for(local i = 0; i < 0x2000; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);
	cpu_write(d, 0xE000, 0x00);
}