﻿function cpu_dump(d, prg_size, prg_size_dummy)
{
	show_log(d, "Dump mapper 0");
	
	if(prg_size==0x4000)
		cpu_read(d, 0xc000, 0x4000);
	else//32k
		cpu_read(d, 0x8000, 0x8000);		
}
function ppu_dump(d, chr_size, chr_size_dummy)
{
	if(chr_size==0x2000)
	ppu_read(d, 0x0000, 0x2000);
}

function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}

function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8000,0x8555,0x82AA,0x8555);
	
	if(prg_size==0x4000)
		prg_flash(d, 0xC000, 0x4000);
	else//32k
		prg_flash(d, 0x8000, 0x8000);
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}

function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);
	chr_flash(d, 0x0000, chr_size);
}


function ram_dump(d, prg_size, banksize)
{
	//cpu_write
	//ram_read_write
	for(local i = 0; i < 0x2000; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);
}