/***************************************
 MMC4 Mapper10
 PRG MAX 256K
 CHR MAX 128K
 
 Last update:2022/05/12
      add support sram r/w sram function
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000) - 2; i += 2){
		cpu_write(d, 0xA000, i/2);
		cpu_read(d, 0x8000, 0x4000);
	}
	cpu_read(d, 0xc000, 0x4000);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x1000; i+=1){
		cpu_write(d,0xBFFF,i);
		cpu_write(d,0xCFFF,i);
		ppu_read(d, 0x0000, 0x1000);
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0xC555,0xF0);
	cpu_write_flash(d,0xC555,0xAA);
	cpu_write_flash(d,0xC2AA,0x55);
	cpu_write_flash(d,0xC555,0x80);
	cpu_write_flash(d,0xC555,0xAA);
	cpu_write_flash(d,0xC2AA,0x55);
	cpu_write_flash(d,0xC555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xC000,0xC555,0xC2AA,0xC555);
	for(local i = 0; i < (prg_size/0x2000) - 2; i += 2){
		cpu_write(d, 0xA000, i/2);
		prg_flash(d, 0x8000, 0x4000);
		if(prg_size==0x20000)//128K
		{
			cpu_write(d, 0xA000, 8|(i/2));
			prg_flash(d, 0x8000, 0x4000);
		}
	}
	prg_flash(d, 0xc000, 0x4000);
	if(prg_size==0x20000)//128K
	{
		cpu_write(d, 0xA000, 7);
		prg_flash(d, 0x8000, 0x4000);
	}
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0xB000, 0);
	cpu_write(d, 0xC000, 0);
	cpu_write(d, 0xD000, 0);
	cpu_write(d, 0xE000, 0);

	
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	for(local i = 0; i < chr_size/0x1000; i+=2){
		cpu_write(d, 	0xB000,i, 
						0xC000,i, 
						0xD000,i|1,
						0xE000,i|1);
		chr_flash(d, 0x0000, 0x2000);
	}
}

function ram_dump(d, prg_size, banksize)
{
	for(local i = 0; i < prg_size; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);
}
