/***************************************
 MMC3 Base DQ7
 20181216
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	cpu_write(d, 0xa001, 0); //disable W-RAM
	for(local i = 0; i < (prg_size/0x2000); i += 2)
	{
		if(i==0x00){
			cpu_write(d, 0x8000,0,0x8001,0x00);
		}
		if(i==0x40){
			cpu_write(d, 0x8000,0,0x8001,0xFF);
		}
	
		cpu_write(d, 0x8000, 6);
		cpu_write(d, 0x8001, i);
		cpu_write(d, 0x8000, 7);
		cpu_write(d, 0x8001, i | 1);
		cpu_read(d, 0x8000, 0x4000);
	}
}
function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d, 0xa001, 0); //disable W-RAM
	//5555 bank x 0xD555
	//2AAA bank 1 0x8AAA
	cpu_write(d,0x8000,0x6);
	cpu_write(d,0x8001,0x1);
	
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xD555,0xD555,0x8AAA,0xD555);

	cpu_write(d, 0xa001, 0); //disable W-RAM
	for(local i = 0; i < (prg_size/0x2000); i += 2)
	{
		if(i==0x00){
			cpu_write(d, 0x8000,0,0x8001,0x00);
		}
		if(i==0x40){
			cpu_write(d, 0x8000,0,0x8001,0xFF);
		}
	
		cpu_write(d, 0x8000, 6);
		cpu_write(d, 0x8001, i);
		cpu_write(d, 0x8000, 7);
		cpu_write(d, 0x8001, i | 1);
		prg_flash(d, 0x8000, 0x4000);
	}
}

function ram_dump(d, prg_size, banksize)
{
	//cpu_write
	//ram_read_write
	cpu_write(d, 0xa001, 0x80);
	for(local i = 0; i < 0x2000; i += 0x400)
	ram_read_write(d, 0x6000+i, 0x400);
	cpu_write(d, 0xa001, 0x40);
}
