/***************************************
iNES Mapper 255 is apparently assigned 
to the 110-in-1 multicart.

A~[1BMZ PPPP  PpCC CCCC]
    ||| ||||  |||| ||||
    +-----------++-++++ - Select 8 KiB CHR at PPU $0000
    ||| ||||  ||
    +---++++--++------- - Select 16 KiB PRG at CPU $8000 and $C000 if Z=1
    +---++++--+-------- - Select 32 KiB PRG at CPU $8000 if Z=0
     |+---------------- - Select PRG bank size: 0-32K 1-16K
     +----------------- - Nametable mirroring: 0-PPUA10 ("vertical") 1-PPUA11 ("horizontal")
	  
***************************************/
function cpu_dump(d, prg_size, crc)
{
	for(local i = 0; i < (prg_size/0x8000); i += 1)
	{
		cpu_write(d, 0x8000+i<<6, i<<6);
		cpu_read(d, 0x8000, 0x8000);
	}
}
function ppu_dump(d, chr_size, crc)
{
	for(local i = 0; i < chr_size/0x2000; i+=1)
	{
		cpu_write(d, 0x8000+i,i);
		ppu_read(d, 0x0000, 0x2000);
	}
}