/***************************************
 CNROM Mapper3
 Last update:2025/10/15
***************************************/
function cpu_dump(d, prg_size, prg_size_dummy)
{
	if(prg_size==0x4000)
		cpu_read(d, 0xc000, 0x4000);
	else//32k
		cpu_read(d, 0x8000, 0x8000);
}
function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8000,0x8555,0x82AA,0x8555);
	
	if(prg_size==0x4000)
		prg_flash(d, 0xc000, 0x4000);
	else//32k
		prg_flash(d, 0x8000, 0x8000);
}
function ppu_dump(d, chr_size, crc)
{
	if(0x7EB4CC03==crc)//King's Knight (Japan)
	{
		show_log(d, "King's Knight (Japan)");
		for(local i = 0; i < chr_size/0x2000; i+=1){			
			cpu_write(d, 0xB3BB+i,0xCC+i);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xBB89A88E==crc)//ソロモンの鍵
	{
		show_log(d, "Solomon no Kagi (Japan)");
		for(local i = 0; i < chr_size/0x2000; i+=1){			
			cpu_write(d, 0x80EF+i,0x10+i);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0x476D96F8==crc)//Family Trainer 1
	{
		show_log(d, "Family Trainer 1");			
		cpu_write(d, 0xFBCF,0x3C); ppu_read(d,0x0000, 0x2000);
		cpu_write(d, 0xFBD1,0xB5); ppu_read(d,0x0000, 0x2000);
		cpu_write(d, 0xFBD0,0x7A); ppu_read(d,0x0000, 0x2000);
		cpu_write(d, 0xFBD2,0xF3); ppu_read(d,0x0000, 0x2000);
	}
	else if(0x4EE57031==crc)//TCF-TM つっぱり大相撲
	{
		show_log(d, "Tsuppari Oozumou (Japan)");
		for(local i = 0; i < chr_size/0x2000; i+=1){			
			cpu_write(d, 0xB800+i,0x10+i);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xC31907F7==crc)//高橋名人の冒険島
	{
		show_log(d, "Takahashi Meijin no Bouken-jima (Japan)");
		for(local i = 0; i < chr_size/0x2000; i+=1){			
			cpu_write(d, 0xB7FF+i,i+0x30);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0x89D4E4F8==crc)//tetris
	{
		show_log(d, "Tetris (Bulletproof) (Japan)");
		cpu_write(d, 0x8002,0x82);
		for(local i = 0; i < chr_size/0x2000; i+=1){			
			cpu_write(d, 0xC001+i,i);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0x424826EA==crc)//BANANA
	{
		show_log(d, "Banana (Japan)");
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0xFF9F+i+2, i+0x10+2);//3,13 2,12
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xc0d3e092==crc)
	{
		show_log(d, "Gegege no Kitarou - Youkai Daimakyou (Japan)");
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0xF084+i, i+0x30);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if((0x73DB3A26==crc)||(0x6593CE0D==crc)||(0x757FBE4==crc))
	//Hokuto no Ken (Japan) 2022/04/07
	//Nagagutsu o Haita Neko 2022/06/15
	{
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0x8000+i, i+0x30);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xA368EAAD==crc)
	{
		show_log(d, "Star Soldier");		
		cpu_write(d, 0xD044, 0x30);		
		cpu_write(d, 0xD045, 0x31);		
		cpu_write(d, 0xD046, 0x32);		
		cpu_write(d, 0xD047, 0x33);		
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0xD044+i, i+0x30);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0x4a93553d==crc)
	{
		show_log(d, "Dump Meikyuu Kumikyoku - Milon no Daibouken");
		cpu_write(d, 0xe4f1, 0x30);
		cpu_write(d, 0xe4f3, 0x32);		
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0xe4f1+i, i+0x30);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0x0ac7ff27==crc)
	{
		cpu_write(d, 0x8000, 0x30);
		cpu_write(d, 0x8001, 0x31);
		cpu_write(d, 0x8002, 0x32);
		cpu_write(d, 0x8003, 0x33);
		
		show_log(d, "dump Seikima II");
		
		//Title: Seikima II - Akuma no Gyakushuu! (Japan)
		//Description: 聖飢魔Ⅱ 悪魔の逆襲！
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0x8000+i, i+0x30);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xF99BFCC1==crc)//Buggy Popper (Japan)
	{
		cpu_write(d, 0x809C, 0);
		//8225 33
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0x8222+i, i+0x30);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0x5CB00D24==crc)//Hanafuda Yuukyou Den - Nagarebana Oryuu
	{
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0x80ae+i, i+8);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0x3636F632==crc)//ASO: Armored Scrum Object 
	{
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0x8255, 0x30+i);
			cpu_write(d, 0x8255, 0x30+i);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xe8175c0c==crc)//Gradius (Japan)
	{
		show_log(d, "dump Gradius");
		cpu_write(d, 0x8ACE+0, 0x30+0);
		cpu_write(d, 0x8ACE+0, 0x30+0);		
		ppu_read(d,0x0000, 0x2000);
		
		cpu_write(d, 0x8ACE+2, 0x30+1);
		cpu_write(d, 0x8ACE+2, 0x30+1);		
		ppu_read(d,0x0000, 0x2000);
		
		cpu_write(d, 0x8ACE+1, 0x30+2);
		cpu_write(d, 0x8ACE+1, 0x30+2);		
		ppu_read(d,0x0000, 0x2000);
		
		cpu_write(d, 0x8ACE+3, 0x30+3);
		cpu_write(d, 0x8ACE+3, 0x30+3);		
		ppu_read(d,0x0000, 0x2000);
		
		
	}
	else if(0xF4027304==crc)//Mickey Mouse - Fushigi no Kuni no Daibouken (Japan)
	{
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0xDB9A+i, 0x30+i);
			cpu_write(d, 0xDB9A+i, 0x30+i);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xe2e0ecb7==crc)//Chou Robot Seimeitai Transformers
	{
		show_log(d, "Chou Robot Seimeitai Transformers");
		cpu_write(d, 0x8003, 0x03);		
		for(local i = 0; i < chr_size/0x2000; i+=1){
			cpu_write(d, 0x8000+i, i);
			ppu_read(d,0x0000, 0x2000);
		}
	}
	else if(0xEABDA5C4==crc)//Test DQ1
	{
		show_log(d, "dump dq1");
		cpu_write(d, 0xC5F2, 0x30);
		ppu_read(d,0x0000, 0x2000);		
		cpu_write(d, 0xC5F8, 0x31);
		ppu_read(d,0x0000, 0x2000);		
		cpu_write(d, 0xC5FE, 0x32);
		ppu_read(d,0x0000, 0x2000);		
		cpu_write(d, 0xC604, 0x33);
		ppu_read(d,0x0000, 0x2000);
	}
	else{		
		//cpu_write(d, 0x8000, 0x30);
		//cpu_write(d, 0x8001, 0x31);
		//cpu_write(d, 0x8002, 0x32);
		//cpu_write(d, 0x8003, 0x33);		
		show_log(d, "dump normal mapper3");
		for(local i = 0; i < chr_size/0x2000; i+=1)
		{
			//if(crc==0x4EE57031)//Tsuppari Oozumou (Japan) 2022/05/09
			//{
			//	cpu_write(d, 0xB800+i, i|0x10);
			//}
			//else
			//{
			//	cpu_write(d, 0xFFFF, i);
			//}
			//ppu_read(d,0x0000, 0x2000);
			
			cpu_write(d, 0x8000, i);			
			ppu_read(d,0x0000, 0x2000);
		}
		//cpu_write(d, 0x8000, 0x30);
	}
	
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);
	for(local i = 0; i < chr_size/0x2000; i+=1){
		cpu_write(d, 0xC000, i);
		chr_flash(d,0x0000, 0x2000);
	}
}