/***************************************
 Namco 118 with special CHR banking
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000) - 2; i += 2){
		cpu_write(d, 0x8000, 6,0x8001, i,0x8000, 7,0x8001, i|1);
		cpu_read(d, 0x8000, 0x4000);
	}
	cpu_read(d, 0xc000, 0x2000 * 2);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x400; i+=4)
	{
		//first 64KB
		if(i<64)
		{
			cpu_write(d, 	0x8000,0,0x8001,i|0, 
							0x8000,1,0x8001,i|2);
			ppu_read(d, 0x0000, 0x1000);
		}
		else{
			//next 64KB
			cpu_write(d, 	0x8000,2,0x8001,(i|0x40)|0, 
							0x8000,3,0x8001,(i|0x40)|1,
							0x8000,4,0x8001,(i|0x40)|2, 
							0x8000,5,0x8001,(i|0x40)|3);
			ppu_read(d, 0x1000, 0x1000);
		}
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d,0x8000,0x6);
	cpu_write(d,0x8001,0x1);
	
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8000,0x8555,0x82AA,0x8555);
	cpu_write(d,0x8000,6,0x8001,0);

	for(local i = 0; i < (prg_size/0x2000)-2; i += 1){
		cpu_write(d, 0x8000, 6);
		cpu_write(d, 0x8001, i|0);
		prg_flash(d, 0x8000, 0x2000);
	}
	prg_flash(d, 0xc000, 0x2000 * 2)
}

function ppu_erase(d, chr_size, chr_size_dummy)
{	
	cpu_write(d, 0x8000, 2);//1000-400
	cpu_write(d, 0x8001, 0x0A);	// 0x12AA
	cpu_write(d, 0x8000, 3);//1000-400
	cpu_write(d, 0x8001, 0x15);// 0x1555

	
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		if(i<64)
		{
			cpu_write(d, 0x8000, 0);
			cpu_write(d, 0x8001, i|0);
			cpu_write(d, 0x8000, 1);
			cpu_write(d, 0x8001, i|2);
			chr_flash(d, 0x0000, 0x1000);
		}
		else{			
			cpu_write(d, 	0x8000,2,0x8001,(i|0x40)|0, 
							0x8000,3,0x8001,(i|0x40)|1,
							0x8000,4,0x8001,(i|0x40)|2, 
							0x8000,5,0x8001,(i|0x40)|3);
			chr_flash(d, 0x1000, 0x1000);
		}
	}
}

