/***************************************
 VRC4 Mapper23
 updte 20201214
***************************************/
function vrc4_cpu_dump(d, pagesize, banksize, r0, r1)
{
	local a2 = 1 << r1;
	cpu_write(d, 0x9000 | a2, 0);
	for(local i = 0; i < pagesize - 2; i += 2){
		cpu_write(d, 0x8000, i);
		cpu_write(d, 0xa000, i | 1);
		cpu_read(d, 0x8000, banksize * 2);
	}
	cpu_write(d, 0x9000 | a2, 0x02);
	cpu_write(d, 0x8000, 0x1e);
	cpu_read(d, 0xc000, banksize * 2);
}
function cpu_dump(d,prg_size,reset_crc)
{
	if(reset_crc==0xb0414197)//Tiny Toon Adventures (Japan)
	{
		show_log(d, "dump as Tiny Toon Adventures/RC860");
		//edit 20200302
		//       A0 A1
		//VRC4e  A2 A3
		//Swap Mode 0x9002 bit1
		cpu_write(d, 0x9008, 0);
		for(local i = 0; i < (prg_size/0x2000) - 2; i += 2)
		{
			cpu_write(d, 0x8000, i|0);
			cpu_read(d, 0x8000, 0x2000);
			cpu_write(d, 0xA000, i|1);
			cpu_read(d, 0xA000, 0x2000);
		}
		cpu_read(d, 0xC000, 0x4000 );		
	}
	else if(reset_crc==0x2cd63d8c)//Parodius da! (J)
	{
		vrc4_cpu_dump(d,prg_size/0x2000,0x2000, 2, 3);
	}
	else if(0x0E908D2C==reset_crc)//悪魔城すぺしゃる ぼくドラキュラ君
	{//Akumajou Special: Boku Dracula-kun 
		/*
		9008 00
		9000 00
		8FFF 0C bank prg 8000
		AFFF 0D bank prg A000
		*/
		show_log(d, "dump Boku Dracula-kun");
		cpu_write(d, 0x9008, 0);
		cpu_write(d, 0x9000, 0);
		for(local i = 0; i < (prg_size/0x2000) - 2; i += 2)
		{
			cpu_write(d, 0x8FFF, i|0);
			cpu_write(d, 0xAFFF, i|1);
			cpu_read(d, 0x8000, 0x4000);
		}
		cpu_read(d, 0xC000, 0x4000 );			
	}
	else
	{		
		//show_log(d, "dump normal vrc");
		//vrc4_cpu_dump(d,prg_size/0x2000,0x2000, 0, 1);		
		for(local i = 0; i < (prg_size/0x2000) - 1; i += 1)
		{
			cpu_write(d, 0xA000, i);
			cpu_read(d, 0xA000, 0x2000);
		}
		cpu_read(d, 0xE000, 0x2000 );	
	}
}

function ppu_bank_set(d, addr, i, j, r0, r1)
{
	local a1 = (1 << r0);
	local a2 = (1 << r1);
	local a3 = a1 | a2; 

	//cpu_write(d, addr | a1, i >> 4);
	//cpu_write(d, addr |  0, i & 0xf);
	//cpu_write(d, addr | a3, j >> 4);
	//cpu_write(d, addr | a2, j & 0xf);
	cpu_write(d, addr | a1, i >> 4,addr, i & 0xf,addr | a3, j >> 4,addr | a2, j & 0xf);
}
function vrc4_ppu_dump(d, pagesize, banksize, r0, r1)
{
	for(local i = 0; i < pagesize; i += 8){
		ppu_bank_set(d, 0xb000, i | 0, i | 1, r0, r1);
		ppu_bank_set(d, 0xc000, i | 2, i | 3, r0, r1);
		ppu_bank_set(d, 0xd000, i | 4, i | 5, r0, r1);
		ppu_bank_set(d, 0xe000, i | 6, i | 7, r0, r1);
		ppu_read(d, 0x0000, banksize * 8);
	}
}
function ppu_dump(d, chr_size, reset_crc)
{
	if( (reset_crc==0x1f7e6a84)||//contra
		(reset_crc==0xdf781103)||//wai wai world
		(reset_crc==0x4887BEAF)||//Dragon Scroll
		(reset_crc==0xF2C2B3ED)||//Ganbare Goemon 2
		(reset_crc==0x942BCD83)||//Getsu Fuuma Den 
		(reset_crc==0x9859D73C)//Jarinko Chie
		)
	{
		vrc4_ppu_dump(d, chr_size/0x400, 0x400, 0, 1);
	}
	else{
		vrc4_ppu_dump(d, chr_size/0x400, 0x400, 2, 3);
	}
}


function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d,0x9008,0);
	cpu_write(d,0x8000,0);
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xA000,0xA555,0xA2AA,0xA555);
	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0xA000, i);
		prg_flash(d, 0xA000, 0x2000);
	}
	prg_flash(d, 0xE000, 0x2000);
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0xB000, 0);
	cpu_write(d, 0xB001, 0);
	cpu_write(d, 0xB002, 1);
	cpu_write(d, 0xB003, 0);
	
	ppu_write(d,0x555,0xF0);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x80);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x555,0x555,0x2AA,0x555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		cpu_write(d, 0xB000, (i>>0)&0xF);
		cpu_write(d, 0xB001, (i>>4)&0xF);
		cpu_write(d, 0xB002, ((i|1)>>0)&0xF);
		cpu_write(d, 0xB003, ((i|1)>>4)&0xF);
		cpu_write(d, 0xC000, ((i|2)>>0)&0xF);
		cpu_write(d, 0xC001, ((i|2)>>4)&0xF);
		cpu_write(d, 0xC002, ((i|3)>>0)&0xF);
		cpu_write(d, 0xC003, ((i|3)>>4)&0xF);
		chr_flash(d, 0x0000, 0x1000);
	}
}

