/***************************************
 Fong Shen Bang
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < prg_size/0x2000; i += 4){
		cpu_write(d, 0x6000, i|0);
		cpu_write(d, 0x6001, i|1);
		cpu_write(d, 0x6002, i|2);
		cpu_write(d, 0x6003, i|3);
		cpu_read(d, 0x8000, 0x8000);
	}
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x800; i+=4){
		cpu_write(d, 0x6004, i|0);
		cpu_write(d, 0x6005, i|1);
		cpu_write(d, 0x6006, i|2);
		cpu_write(d, 0x6007, i|3);		
		ppu_read(d, 0x0000, 0x2000);
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{	
	cpu_write_flash(d,0xD555,0xF0);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x80);
	cpu_write_flash(d,0xD555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0xD555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xD555,0xD555,0x8AAA,0xD555);

	for(local i = 0; i < (prg_size/0x2000); i += 4){
		cpu_write(d, 0x6000, i|0);
		cpu_write(d, 0x6001, i|1);
		cpu_write(d, 0x6002, i|2);
		cpu_write(d, 0x6003, i|3);
		prg_flash(d, 0x8000, 0x8000);
	}
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0x6004, 0);
	ppu_write(d,0x555,0xF0);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x80);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x555,0x555,0x2AA,0x555);

	for(local i = 0; i < (chr_size/0x800); i += 4){
		cpu_write(d, 0x6004, i|0);
		cpu_write(d, 0x6005, i|1);
		cpu_write(d, 0x6006, i|2);
		cpu_write(d, 0x6007, i|3);		
		chr_flash(d, 0x0, 0x2000);
	}
}

