/***************************************
 VRC4B Mapper25
 20230109 Update:
          VRC4d	352400	A3	A2	$x000, $x008, $x004, $x00C	25	2
		  Teenage Mutant Ninja Turtles 2 - The Manhattan Project (Japan)
***************************************/
function vrc4_cpu_dump(d, pagesize, banksize, r0, r1)
{
	local a2 = 1 << r1;
	cpu_write(d, 0x9000 | a2, 0);
	for(local i = 0; i < pagesize - 2; i += 2){
		cpu_write(d, 0x8000, i);
		cpu_write(d, 0xa000, i | 1);
		cpu_read(d, 0x8000, banksize * 2);
	}
	cpu_write(d, 0x9000 | a2, 0x02);
	cpu_write(d, 0x8000, 0x1e);
	cpu_read(d, 0xc000, banksize * 2);
}
function cpu_dump(d,prg_size,crc)
{
	if( (crc==0xc2c3292c)||//Teenage Mutant Ninja Turtles
		(crc==0x41926B9D)//Teenage Mutant Ninja Turtles II
		)
	{
		/*
		<feature name="vrc4-pin3" value="PRG A2" />
		<feature name="vrc4-pin4" value="PRG A3" />
		9004 00
		8FFF 18 bank 8000-9FFF
		AFFF 19 bank A000-BFFF
		*/
		show_log(d, "Teenage Mutant Ninja Turtles");
		vrc4_cpu_dump(d,prg_size/0x2000,0x2000, 3, 2);
		
	}
	else vrc4_cpu_dump(d,prg_size/0x2000,0x2000, 1, 0);
}


function ppu_bank_set(d, addr, i, j, r0, r1)
{
	local a1 = (1 << r0);
	local a2 = (1 << r1);
	local a3 = a1 | a2;

	//cpu_write(d, addr | a1, i >> 4);
	//cpu_write(d, addr, i & 0xf);
	//cpu_write(d, addr | a3, j >> 4);
	//cpu_write(d, addr | a2, j & 0xf);
	cpu_write(d, addr | a1, i >> 4,addr, i & 0xf,addr | a3, j >> 4,addr | a2, j & 0xf);
}
function vrc4_ppu_dump(d, pagesize, banksize, r0, r1)
{
	for(local i = 0; i < pagesize; i += 8){
		ppu_bank_set(d, 0xb000, i | 0, i | 1, r0, r1);
		ppu_bank_set(d, 0xc000, i | 2, i | 3, r0, r1);
		ppu_bank_set(d, 0xd000, i | 4, i | 5, r0, r1);
		ppu_bank_set(d, 0xe000, i | 6, i | 7, r0, r1);
		ppu_read(d, 0x0000, banksize * 8);
	}
}

function ppu_dump(d,chr_size,reset_crc)
{
	if( (reset_crc==0xc2c3292c)||//Teenage Mutant Ninja Turtles
		(reset_crc==0x41926B9D)//Teenage Mutant Ninja Turtles II
		)
		vrc4_ppu_dump(d, chr_size/0x400, 0x400, 3, 2);
	else
		vrc4_ppu_dump(d, chr_size/0x400, 0x400, 1, 0);
}

function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write(d,0x9008,0);
	cpu_write(d,0x8000,0);
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x82AA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0xA000,0xA555,0xA2AA,0xA555);
	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0xA000, i);
		prg_flash(d, 0xA000, 0x2000);
	}
	prg_flash(d, 0xE000, 0x2000);
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0xB000, 0);
	cpu_write(d, 0xB001, 0);
	cpu_write(d, 0xB002, 1);
	cpu_write(d, 0xB003, 0);
	
	ppu_write(d,0x555,0xF0);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x80);
	ppu_write(d,0x555,0xAA);
	ppu_write(d,0x2AA,0x55);
	ppu_write(d,0x555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x555,0x555,0x2AA,0x555);

	for(local i = 0; i < (chr_size/0x400); i += 4){
		cpu_write(d, 0xB000, (i>>0)&0xF);
		cpu_write(d, 0xB002, (i>>4)&0xF);
		cpu_write(d, 0xB001, ((i|1)>>0)&0xF);
		cpu_write(d, 0xB003, ((i|1)>>4)&0xF);
		cpu_write(d, 0xC000, ((i|2)>>0)&0xF);
		cpu_write(d, 0xC002, ((i|2)>>4)&0xF);
		cpu_write(d, 0xC001, ((i|3)>>0)&0xF);
		cpu_write(d, 0xC003, ((i|3)>>4)&0xF);
		chr_flash(d, 0x0000, 0x1000);
	}
}

