/***************************************
 IREM
 20240213 
   $8000:  PRG Reg 0 (8k @ $8000 -or- 8k @ $C000)
   $A000:  PRG Reg 1 (8k @ $A000)
 
   $B000-$B007:  CHR regs
 
   $9000:  [X... ....]  PRG bank layout
     Very similar to VRC4 or MMC3
     %0 = bank at $8000 set by writes to $8000, bank at $C000 always $3E
     %1 = bank at $C000 set by writes to $8000, bank at $8000 always $3E

     bank at $E000 always $3F
***************************************/
function cpu_dump(d, prg_size, prg_size_dummy)
{
	local i;
	for(i = 0; i < (prg_size/0x2000) - 1; i += 1){
		cpu_write(d, 0x9000, 0x40);
		cpu_write(d, 0x8000, i);
		cpu_read(d, 0x8000, 0x2000);
	}
	cpu_read(d, 0xE000, 0x2000);
}
function ppu_dump(d, chr_size, chr_size_dummy)
{
	for(local i = 0; i < (chr_size/0x400); i += 4){
		//local ar = [i, i|2, i|4, i|5, i|6, i|7];
		cpu_write(d, 0xB000,i,0xB001, i|1,0xB002, i|2,0xB003, i|3);
		ppu_read(d, 0x0000, 0x400 * 4);
	}
}