/***********************************************************
 GxROM Mapper66
 
 Bank select ($8000-$FFFF)
  7  bit  0
  ---- ----
  xxPP xxCC
    ||   ||
    ||   ++- Select 8 KB CHR ROM bank for PPU $0000-$1FFF
    ++------ Select 32 KB PRG ROM bank for CPU $8000-$FFFF
  Bit 5 is not used on MHROM, which supports only 64 KB PRG.
  
  Dragon Ball - Shen Long no Nazo (Japan)
  PRG:FFCC,A<<2:A<<4
  CHR:FFCC,A<<0:A<<0
  
 Last update:2024/10/29 
***********************************************************/
function cpu_dump(d, prg_size, crc)
{	
	local address = 0xffcc;
	
	//PRG A+i,i<<4
	//CHR A+i<<2,i
	//00 10 20 30
	//01 11 21 31
	//02 12 22 32
	//03 13 23 33
	if( crc==0xEC2611CF ) address=0x812F;//Takahashi Meijin no Bugutte Honey (Japan)
	if( crc==0x88e4847e ) address=0x8261;//Doraemon (Japan)
		
		
	for(local i = 0; i < (prg_size/0x8000); i += 1)
	{
		//mapper140 compatible
		cpu_write(d, 0x7FFF,i<<4);
		cpu_write(d, address+(i<<2),i<<4);
		
		cpu_read(d, 0x8000, 0x8000);
	}
	
	
	//cpu_write(d, 0x7FFF,0);//reset mapper140
	cpu_write(d, address,0);
}
function ppu_dump(d, chr_size, crc)
{
	local address = 0xffcc;
	
	if( crc==0xEC2611CF ) address=0x812F;//Takahashi Meijin no Bugutte Honey (Japan)
	if( crc==0x88e4847e ) address=0x8261;//Doraemon (Japan)
		
	for(local i = 0; i < chr_size/0x2000; i+=1)
	{
		//mapper140 compatible
		//cpu_write(d, 0x7FFF,i);
		cpu_write(d, address+(i<<2),i);

		ppu_read(d, 0x0000, 0x2000);
	}
}