﻿/***************************************
 Mapper80 
 Last Update:20230316
   Fudou Myouou Den
   7EFC banked
 
 Last Update:20230302
 * Change RAM Read/Write offset.
 
 MMC
   $7EF0-7EF5:  CHR Regs 01 23 4 5 6 7
     
   $7EF6,7EF7:  [.... ...M]  Mirroring
    0 = Horz
    1 = Vert
	 
   $7EFA,7EFB:  PRG Reg 0 (8k @ $8000)
   $7EFC,7EFD:  PRG Reg 1 (8k @ $A000)
   $7EFE,7EFF:  PRG Reg 2 (8k @ $C000)
   
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000)-1; i += 1){
		cpu_write(d, 0x7EFA, i);
        cpu_read(d, 0x8000, 0x2000);
    }
    cpu_read(d, 0xE000, 0x2000);
}

function ppu_dump(d, chr_size, banksize)
{
    for(local i = 0; i < chr_size/0x400; i+=4){
		
		cpu_write(d, 0x7EF2,i|0,0x7EF3,i|1,0x7EF4,i|2,0x7EF5,i|3);
		ppu_read(d, 0x1000, 0x400 * 4);
	}
}

function ram_dump(d, prg_size, banksize)
{
	cpu_write(d, 0x7EF8, 0xA3);//enable sram
	//cpu_write
	//ram_read_write
	// $7F00-7FFF:  128 Bytes of RAM, mirrored once.
	for(local i = 0; i < 0x2000; i += 0x80)
	ram_read_write(d, 0x7F00, 0x80);

	cpu_write(d, 0x7EF8, 0xFF);//disable sram
}