/***************************************
 iNES Mapper 091
 Super Fighter III
***************************************/
function cpu_dump(d, prg_size, banksize)
{
	for(local i = 0; i < (prg_size/0x2000) - 2; i += 2){
		cpu_write(d, 0x7000, i|0);
		cpu_write(d, 0x7001, i|1);
		cpu_read(d, 0x8000, 0x4000);
	}
	cpu_read(d, 0xc000, 0x2000 * 2);
}
function ppu_dump(d, chr_size, banksize)
{
	for(local i = 0; i < chr_size/0x400; i+=8){
		cpu_write(d, 0x6000 i/2|0);
		cpu_write(d, 0x6001 i/2|1);
		cpu_write(d, 0x6002 i/2|2);
		cpu_write(d, 0x6003 i/2|3);
		ppu_read(d, 0x0000, 0x400 * 8);
	}
}

function cpu_erase(d, prg_size, prg_size_dummy)
{
	cpu_write_flash(d,0x8555,0xF0);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x80);
	cpu_write_flash(d,0x8555,0xAA);
	cpu_write_flash(d,0x8AAA,0x55);
	cpu_write_flash(d,0x8555,0x10);
}
function cpu_flash(d, prg_size, prg_size_dummy)
{
	flash_configure(d,0x8555,0x8555,0x8AAA,0x8555);
	for(local i = 0; i < (prg_size/0x2000) - 2; i += 2){
		cpu_write(d, 0x7000, i|0);
		cpu_write(d, 0x7001, i|1);
		prg_flash(d, 0x8000, 0x4000);
	}
	prg_flash(d, 0xc000, 0x2000 * 2);	
}

function ppu_erase(d, chr_size, chr_size_dummy)
{
	cpu_write(d, 0x6000, 0);
	cpu_write(d, 0x6001, 1);
	cpu_write(d, 0x6002, 2);
	cpu_write(d, 0x6003, 3);
	
	ppu_write(d,0x1555,0xF0);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x80);
	ppu_write(d,0x1555,0xAA);
	ppu_write(d,0x12AA,0x55);
	ppu_write(d,0x1555,0x10);
}
function ppu_flash(d, chr_size, chr_size_dummy)
{
	flash_configure(d,0x1555,0x1555,0x12AA,0x1555);

	for(local i = 0; i < chr_size/0x400; i+=8){
		cpu_write(d, 0x6000 i/2|0);
		cpu_write(d, 0x6001 i/2|1);
		cpu_write(d, 0x6002 i/2|2);
		cpu_write(d, 0x6003 i/2|3);
		chr_flash(d, 0x0000, 0x400 * 8);
	}
}

